## **Sommaire**

Tu veux animer un module d'autodéfense numérique, excellente idée ! Tu trouveras dans ce document toutes les infos pour pouvoir le faire :

- Les objectifs
- Une vision de la culture de sécurité
- Les angles de transmission
- Les documents
- L'animation
- Les concepts clés de la réduction des risques
- Quelques ressources

Pour toute question, n'hésite pas à envoyer un mail à *atelier_numerique@systemli.org*.

## Les objectifs

Vous pouvez utiliser cet atelier pour ne répondre qu'à certains de ces objectifs !

- Partager une culture de la sécurité numérique
- Comprendre des notions fondamentales de l'informatique (c'est quoi un ordinateur, un serveur, un navigateur web, un système d'exploitation)
- Comprendre schématiquement le fonctionnement d'internet (c'est quoi un fournisseur de service, comment l'information circule entre les marchines)
- Savoir à quelles types d'information la police à accès en fonction des outils numériques utilisés
- Comprendre à quoi servent les outils : VPN, Tor, https, Tails, OpenPGP
- Augmenter la capacité de choisir des outils
- Savoir trouver des ressources de confiance
- Comprendre des concepts de réduction des risques

## Une vision de la culture de sécurité

Par culture de sécurité, on entend :

- une manière commune de comprendre la surveillance et la répression
- une manière commune d'en parler et d'agir en conséquence

Notre culture de sécurité se base sur les idées suivantes :

- nos pratiques de sécurité augmentent notre capacité d'agir : on doit être plus fort.es et avoir plus de marge de manoeuvre après avoir choisi des outils et pratiques communes.
- nous prenons en compte nos états émotionnels et nous prenons soin de nos relations.
- un "bonne pratique de sécurité" est toujours dépendante d'un groupe et d'un contexte particulier, 
- (s')Imposer des pratiques de sécurité (sans chercher à comprendre les possibilités et limites des personnes concernées pour trouver un compromis entre réalité et idéal de sécurisation) est une impasse. 
- nous questionnons régulièrement nos pratiques pour les faire évoluer

## Les angles de transmission

L'atelier est pensé pour :

- Alterner des temps théoriques et des temps de jeu. Les temps théoriques doivent être courts et schématiques. Le jeu permet la mise en pratique et la réappropriation des savoirs.
- S'adresser à des personnes ayant des niveaux variés de compréhension du numérique : ça favorise l'entraide pendant le jeu
- Apporter une couche de complexification théorique si envie : les *Concepts clés* (voir plus bas)
- On trouve ça bien que les explications techniques soient faites par des personnes non-techniciennes (avec un soutien de tekos en arrière-plan pour plus d'exactitude et de nuances), dans l'idée que les personnes non-technicien⋅ne⋅s peuvent peut être avoir une perception des éléments techniques expliqués plus proche de la perception des gens qui participent, et donc que ça peut fluidifier les explications (car le même niveau de vocabulaire technique, par exemple). Et aussi, parfois les personnes techniciennes ont de la difficulté à aller droit au but sans faire des explications pointues dans un langage très technique, ce qui peut être contre-productif face à des personnes qui débutent dans ce milieu là.

## Les documents

Liste des documents nécessaires à l'atelier :

- Déroulé : C'est le guide des animateur-ices tout au long de l'atelier.  
  (Rappel : les éléments qui peuvent être enlevés pour gagner du temps sont *en italique*, les élements **\[ en gras entre crochets \]** sont des infos méta pour les animateurices)

  Le déroulé est à utiliser comme support, mais il peut être modifié évidemment, complété, etc. Dans chaque partie, ça peut être super par exemple de donner des références d'histoires de répression réelles vécues dans vos luttes, pour sourcer et ancrer les éléments amenés dans quelque chose de plus concret.
- Les cartes *infrastructures* = 26 petites (genre A6) x le nombre de groupes + 26 plus grandes pour la correction.   
  Le plus pratique, c'est de les ranger dans des enveloppes pour n'avoir plus qu'à distribuer une enveloppe à chaque groupe à chaque début de partie (oui, ça fait beaucoup d'enveloppes) (Y a des tutos sur internet pour fabriquer des super enveloppes).
- Les cartes *police* = 15 x le nombre de groupes
- Une feuille du *grand internet* A4 x le nombre de groupes

*(Les cartes et feuilles du grand internet peuvent être plastifiées, comme ça c'est réutilisable et pratique pendant l'animation, mais bon, faut avoir le matos...)*

## L'animation

**Installation du jeu :**  
Installer des tables (5 max) entourées de 4, 5 ou 6 chaises.

Si des participant.es s'identifient comme des personnes ayant un niveau avancé sur les questions de numériques, leur proposer de se répartir entre les tables pour enrichir les échanges entre participant·es mais d'avoir la vigilance de laisser de la place à l'expérimentation des personnes moins connaisseuses pendant les phases de jeu.

Mettre sur chaque table une feuille 'le grand internet'

**Équilibre de l'atelier :**  
En début d'atelier, présenter un programme général avec les pauses prévisionnelles. Il est utile de sonder la fatigue du groupe et de s'y adapter.

**Temps théoriques :**  
Cet atelier est pensé pour se suffire à lui-même.  
Cependant, il est largement possible d'imaginer des animations qui vous sont propres pour les temps théoriques. Ces temps théoriques gargnerons à être illustrés et concis.  
En effet, l'intérêt de l'atelier est de faire réfléchir les participant.es en manipulant les cartes. Il est donc conseillé de prendre les questions plutôt durant le temps de jeu pour que la discussion s'appuie dessus.

**Gestion du temps :**  
Il est utile de différencier les questions de clarification et les question d'approfondissement. Ces dernières peuvent être listées pour y revenir à la fin du jeu. Cela permet de ne pas casser la dynamique de jeu, et de ne pas se perdre dans des détails qui ne sont pas pertinents pour toustes.

**Idées supplémentaires :**

- Préparer une affiche "Liste de ressources" à laquelle les participant.es pourront contribuer
- Imprimer à l'avance des brochures qui vous semble pertinentes (auxquelles vous pourrez renvoyer en cas de question d'approfondissement qui ne peuvent être abordées dans l'atelier)

## Les concepts clés

Ces concepts sont des outils théoriques que l'on peut utiliser pour :

- analyser nos pratiques
- nous guider dans nos choix

Nous conseillons de les utiliser dans les parties théoriques si cela permet de rendre plus intelligibles vos explications.

###### ANALYSER NOS PRATIQUES DE REDUCTION DES RISQUES

* Minimisation — Réduire la surface d'attaque et les données récupérables.
* Authentification — Garantir l'origine des informations ou l'identité d'interlocuteurices.
* Intégrité — Vérifier qu'une information n'a pas été modifiée ou corrompue.
* Compartimentation — Une information a d'autant moins de chance d'être compromise ou de tomber entre de mauvaises mains que le nombre de personnes ou d'organisations qui y ont accès est restreint.
* Confidentialité — Limiter l'accès aux informations aux tier·ces autorisé·es.
* Confiance — Dans quelle mesure peut-on se fier à des outils numériques et/ou à des tiers?

###### CHOIX ET DEPLOIEMENTS D'OUTILS

* Compromis praticité/efficacité/sécurité/coût — Chercher un équilibre ou une dynamique entre ces différentes contraintes et objectifs plus ou moins contradictoires.
* Utilisabilité — Quels critères rendraient un logiciel ou une méthode plus ou moins utilisables: efficacité, satisfaction, facilité d'apprentissage, facilité d'appropriation (mémoire), fiabilité (pas de bug). Des critères qui peuvent être contradictoires entre eux.
* Acceptation — Idée de susciter le consentement dans les processus et outils utilisés tout en évitant la résignation ou la contrainte.
* Résilience — Capacité pour l'organisation de continuer à fonctionner après un accident ou dans l'adversité. Penser à : sauvegardes, duplication, documentation, formation, pièces de rechange, localisation des données et des traitements, répartition des services, compétences, partage des savoirs techniques.
* Audit, autoévaluation, contrôle — Vérifier que les prérequis et fonctionnalités censément mises en place le sont bien ; réévaluer les pratiques dans le temps pour les améliorer ou les remettre en cause.

## Quelques ressources

* Sources du jeu "*Network 'n Magic*" : <https://code.ffdn.org/ljf/networkandmagic/>
* *Connaissez-vous vraiment Internet ?*, Article 19, Editions Eyrolles
* *Guide d'autodéfense numérique*, collectif <https://guide.boum.org/>
* *Qu’est-ce qu’internet ? (1/3) : les réseaux* <https://www.librealire.org/cycle-de-conferences-de-benjamin-bayart-qu-est-ce-qu-internet-partie-1-les-reseaux>
* Bibliographie commentée autodéfense juridique et numérique — *Autodéfense numérique : sécurité informatique, protection technique de l’information, outils et pratiques pour l’utilisation des outils*. [https://www.lacoalition.fr/Bibliographie-commentee-autodefense-juridique-et-numerique?rubriques\[\]=19](https://www.lacoalition.fr/Bibliographie-commentee-autodefense-juridique-et-numerique?rubriques%5B%5D=19)
* *TuTORiel Tails,* <https://infokiosques.net/spip.php?article1726>